function scan_value = true_scan(A, N)
    n = size(A, 1);
    subsets = nchoosek(1:n, N);

    K = size(subsets,1);

    %%% compute V, eta^*, \tilde A
    V = ones(1,n) * A * ones(n,1);
    eta = 1 / V^0.5 * A * ones(n,1);
    At = A - eta * eta';

    running_max = 0; %%% initialize 

    for subset_idx = 1:K
        temp_value = 1/N*sum(sum(At(subsets(subset_idx,:), subsets(subset_idx,:)))); %%% compute Z_subset
        
        if temp_value > running_max || subset_idx == 1 %%% store if > running_max 
            running_max = temp_value; 
        end
    end 

    scan_value = running_max;
end


% %%%%%%%%%%%%%% compute scan statistic
%             running_max = 0; %%% initialize 
%     
%             for subset_idx = 1:B %%%generate B random subsets, store max
%         
%                 subset = datasample(1:n, N, 'Replace',false); %%%% generate random subset 
%                 temp_value = 1/(alpha*N)*sum(sum(At(subset, subset))); %%% compute Z_subset
%         
%                 if temp_value > running_max || subset_idx == 1 %%% store if > running_max 
%                     running_max = temp_value; 
%                 end
%             end 
%             
%             scan_values(sample_idx) = running_max; 